/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.resourcestab;

import filenet.sim.api.VWScenarioQueueAssignment;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;

class VWSIMQueuesAddRemovePanel
extends VWAddRemovePanel {
    private VWSIMPropertyData m_propertyData = null;
    private Vector m_availableQueueNames = null;
    private Vector m_selectedQueueNames = null;
    private VWScenarioRoleDefinition m_roleDef = null;

    public VWSIMQueuesAddRemovePanel(VWSIMPropertyData propertyData) {
        super(58);
        this.enableSorting(1280);
        this.setAvailableItemName(VWSIMResource.s_availableQueues);
        this.setSelectedItemName(VWSIMResource.s_selectedQueues);
        this.m_moveUpButton.setToolTipText(VWSIMResource.s_raisePriority);
        this.m_moveDownButton.setToolTipText(VWSIMResource.s_lowerPriority);
        this.m_availableQueueNames = new Vector();
        this.m_selectedQueueNames = new Vector();
        this.m_propertyData = propertyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize(VWScenarioRoleDefinition roleDef) {
        try {
            try {
                this.removeAllResourceNames();
                this.m_propertyData.displayWaitCursor();
                this.m_roleDef = roleDef;
                if (this.m_roleDef != null) {
                    int i;
                    VWScenarioQueueAssignment[] queueAssignments = this.m_roleDef.getQueueAssignments();
                    if (queueAssignments != null) {
                        for (i = 0; i < queueAssignments.length; ++i) {
                            this.m_selectedQueueNames.addElement(queueAssignments[i].getQueueName());
                        }
                    }
                    if (queueAssignments != null) {
                        for (i = 0; i < queueAssignments.length; ++i) {
                            String queueName = queueAssignments[i].getQueueName();
                            if (VWStringUtils.compare(queueName, "Conductor") == 0) continue;
                            this.m_availableQueueNames.addElement(queueName);
                        }
                    }
                }
                this.m_propertyData.getAvailableQueueNames(this.m_availableQueueNames);
                this.initializeLists(this.m_availableQueueNames.toArray(), this.m_selectedQueueNames.toArray());
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var6_7 = null;
                this.m_propertyData.restoreDefaultCursor();
            }
            Object var6_6 = null;
            this.m_propertyData.restoreDefaultCursor();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_propertyData.restoreDefaultCursor();
            throw throwable;
        }
    }

    protected void onAddItemsAction(Object[] items) {
        try {
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    String name = (String)items[i];
                    VWScenarioQueueAssignment queueAssignment = this.m_roleDef.createQueueAssignment(name, 3);
                    this.m_propertyData.setDirty();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        super.onAddItemsAction(items);
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        try {
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    String name = (String)items[i];
                    this.m_roleDef.deleteQueueAssignment(name);
                    this.m_propertyData.setDirty();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return super.onRemoveItemsAction(items);
    }

    protected void moveSelectedItemsUp() {
        super.moveSelectedItemsUp();
        try {
            this.m_roleDef.reorderQueues(this.getSelectedStringItems());
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void moveSelectedItemsDown() {
        super.moveSelectedItemsDown();
        try {
            this.m_roleDef.reorderQueues(this.getSelectedStringItems());
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void removeAllResourceNames() {
        this.m_availableList.removeAll();
        this.m_selectedList.removeAll();
        this.m_availableQueueNames.removeAllElements();
        this.m_selectedQueueNames.removeAllElements();
    }
}

